using System;
using System.Data;
using TABLE = gov.va.med.vbecs.Common.VbecsTables;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;
using Microsoft.Reporting.WinForms;
using System.Reflection;
using System.IO;

namespace gov.va.med.vbecs.BOL
{
	/// <summary>
	/// Summary description for TransfusionReactionWorkupReport.
	/// </summary>
	public class TransfusionReactionWorkupReport:VbecsReport
	{
		
		private const int PreXMInterp = 109;
		private const int PostXMInterp = 110;
        private DataSet _dsReport = new DataSet();

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7877"> 
		///		<ExpectedInput>None</ExpectedInput>
		///		<ExpectedOutput>Transfusion Reaction Workup Report object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7878"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// TransfusionReactionWorkupReport constructor
		/// </summary>
		public TransfusionReactionWorkupReport()
		{
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7879"> 
		///		<ExpectedInput>Valid Patient Transfusion Reaction Guid</ExpectedInput>
		///		<ExpectedOutput>Transfusion reaction workup report object updated</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7880"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Gets or sets Patient Transfusion Reaction unique identifier
		/// </summary>
		public Guid PatientTransfusionReactionGuid
		{
			get
			{
				if (this.ParameterRow.IsNull(TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid))
				{
					return Guid.Empty;
				}
				return (Guid)this.ParameterRow[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid];
			}
			set
			{
				this.ParameterRow[TABLE.PatientTransfusionReaction.PatientTransfusionReactionGuid] = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		/// <summary>
		/// GetPatientTransfusionReactionReport
		/// </summary>
		/// <returns></returns>
		public DataSet GetPatientTransfusionReactionReport()
		{
			string preSpecimenUid = "";
			string postSpecimenUid = "";
			//
			DataSet ds = DAL.PatientTransfusionReaction.GetPatientTransfusionReactionReport(this.PatientTransfusionReactionGuid);
			//
			if (ds.Tables.Count>3)
			{
				ds.Tables[0].Columns.Add(Common.DatabaseConstants.ArtificialColumnNames.PatientDisplayName);
				//
				foreach(DataRow dr in ds.Tables[0].Rows)
				{
					dr[Common.DatabaseConstants.ArtificialColumnNames.PatientDisplayName] = 
						BOL.Patient.BuildDisplayName(dr[TABLE.Patient.PatientFirstName].ToString(),dr[TABLE.Patient.PatientMiddleName].ToString(),dr[TABLE.Patient.PatientLastName].ToString());
					//
					if (!dr.IsNull(ARTIFICIAL.PreNACannedCommentGuid))
					{
						dr[ARTIFICIAL.PreNACommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PreNACannedCommentGuid],dr[ARTIFICIAL.PreNACommentText].ToString());
					}
					if (!dr.IsNull(ARTIFICIAL.PostNACannedCommentGuid))
					{
						dr[ARTIFICIAL.PostNACommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PostNACannedCommentGuid],dr[ARTIFICIAL.PostNACommentText].ToString());
					}
					if (!dr.IsNull(ARTIFICIAL.PreCCCannedCommentGuid))
					{
						dr[ARTIFICIAL.PreCCCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PreCCCannedCommentGuid],dr[ARTIFICIAL.PreCCCommentText].ToString());
					}
					if (!dr.IsNull(ARTIFICIAL.PostCCCannedCommentGuid))
					{
						dr[ARTIFICIAL.PostCCCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.PostCCCannedCommentGuid],dr[ARTIFICIAL.PostCCCommentText].ToString());
					}
					if (!dr.IsNull(ARTIFICIAL.FinalizeCannedCommentGuid))
					{
						dr[ARTIFICIAL.FinalizeCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.FinalizeCannedCommentGuid],dr[ARTIFICIAL.FinalizeCommentText].ToString());
					}
					if (dr.IsNull(TABLE.TransfusionReactionType.TransfusionReactionTypeText))
					{
						dr[TABLE.TransfusionReactionType.TransfusionReactionTypeText] = "Undetermined";
					}
					preSpecimenUid = dr[ARTIFICIAL.PreSpecimenUid].ToString().Trim();
					postSpecimenUid = dr[ARTIFICIAL.PostSpecimenUid].ToString().Trim();
				}
				//
				foreach(DataRow dr in ds.Tables[1].Rows)
				{
					if (Convert.ToInt32(dr[TABLE.PatientSymptom.PatientSymptomId]) == 21)
					{
						string freeTextSymptom = dr[TABLE.PatientSymptom.PatientSymptomName].ToString()+": ";
						if (!dr.IsNull(TABLE.PatientTransfusionComment.CannedCommentGuid))
						{
							freeTextSymptom += BOL.CannedComment.CombinedComment((Guid)dr[TABLE.PatientTransfusionComment.CannedCommentGuid],dr[TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString());
						}
						else
						{
							freeTextSymptom+=dr[TABLE.PatientTransfusionComment.PatientTransfusionCommentText].ToString();
						}
						//
						dr[TABLE.PatientSymptom.PatientSymptomName] = freeTextSymptom;
						break;
					}
				}
				//
				if (ds.Tables[1].Rows.Count == 0)
				{
					foreach(DataColumn col in ds.Tables[1].Columns)
					{
						col.AllowDBNull = true;
					}
					DataRow dr = ds.Tables[1].NewRow();
					dr[TABLE.PatientSymptom.PatientSymptomName] = "No symptoms identified";
					ds.Tables[1].Rows.Add(dr);
				}
				//
				foreach(DataRow dr in ds.Tables[2].Rows)
				{
					if (!dr.IsNull(ARTIFICIAL.BagCannedCommentGuid))
					{
						dr[ARTIFICIAL.BagCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.BagCannedCommentGuid],dr[ARTIFICIAL.BagCommentText].ToString());
					}
					if (!dr.IsNull(ARTIFICIAL.CheckCannedCommentGuid))
					{
						dr[ARTIFICIAL.CheckCommentText] = BOL.CannedComment.CombinedComment((Guid)dr[ARTIFICIAL.CheckCannedCommentGuid],dr[ARTIFICIAL.CheckCommentText].ToString());
					}
					if (!dr.IsNull(Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount))
					{
						if (Convert.ToInt32(dr[Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount])>0)
						{
							dr[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount].ToString()+")";
						}
					}
				}
				//
				if (ds.Tables[2].Rows.Count == 0)
				{
					foreach(DataColumn col in ds.Tables[2].Columns)
					{
						col.AllowDBNull = true;
					}
					DataRow dr = ds.Tables[2].NewRow();
					dr[TABLE.BloodUnit.EyeReadableUnitId] = "None";
					ds.Tables[2].Rows.Add(dr);
				}
				//
				foreach(DataRow dr in ds.Tables[3].Rows)
				{
					if (!dr.IsNull(TABLE.CannedComment.CannedCommentGuid))
					{
						dr[TABLE.BloodUnitTest.TestComments] = BOL.CannedComment.CombinedComment((Guid)dr[TABLE.CannedComment.CannedCommentGuid],dr[TABLE.BloodUnitTest.TestComments].ToString());
					}
					if (!dr.IsNull(Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount))
					{
						if (Convert.ToInt32(dr[Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount])>0)
						{
							dr[TABLE.BloodProduct.ProductShortName] = dr[TABLE.BloodProduct.ProductShortName].ToString()+" ("+dr[Common.DatabaseConstants.ArtificialColumnNames.PooledUnitsCount].ToString()+")";
						}
					}
					if (Convert.ToInt32(dr[TABLE.BloodTestType.BloodTestTypeId]) == PreXMInterp)
					{
						dr[TABLE.PatientSpecimen.SpecimenUid] = dr[ARTIFICIAL.PreSpecimenUid];
					}
					if (!dr.IsNull(TABLE.BloodUnit.BloodUnitGuid))
					{
						if ((Convert.ToInt32(dr[TABLE.BloodTestType.BloodTestTypeId]) != PreXMInterp) &&
							(Convert.ToInt32(dr[TABLE.BloodTestType.BloodTestTypeId]) != PostXMInterp))
						{
							dr[TABLE.PatientSpecimen.SpecimenUid] = "";
						}
					}
					if ((Convert.ToInt32(dr[TABLE.BloodTestType.BloodTestTypeId]) != PreXMInterp) &&
						(Convert.ToInt32(dr[TABLE.BloodTestType.BloodTestTypeId]) != PostXMInterp) &&
						(dr[TABLE.PatientSpecimen.SpecimenUid].ToString().Trim().Length>0))
					{
						if (dr[TABLE.PatientSpecimen.SpecimenUid].ToString().Trim() == preSpecimenUid)
						{
							dr[TABLE.BloodTestType.BloodTestName] = "Pre "+dr[TABLE.BloodTestType.BloodTestName];
						}
						else if (dr[TABLE.PatientSpecimen.SpecimenUid].ToString().Trim() == postSpecimenUid)
						{
							dr[TABLE.BloodTestType.BloodTestName] = "Post "+dr[TABLE.BloodTestType.BloodTestName];
						}
					}
				}
				//
				if (ds.Tables[3].Rows.Count == 0)
				{
					foreach(DataColumn col in ds.Tables[3].Columns)
					{
						col.AllowDBNull = true;
					}
					DataRow dr = ds.Tables[3].NewRow();
					dr[TABLE.BloodTestType.BloodTestName] = "No tests performed";
					ds.Tables[3].Rows.Add(dr);
				}
			}
			//
			return ds;
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7885"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7886"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GenerateAndPrintReport
		/// </summary>
		protected override VbecsReportPrinter createReportPrinter()
		{
            _dsReport = this.GetPatientTransfusionReactionReport();

            BOL.VbecsUser user = new BOL.VbecsUser(this.PrintedBy);
            DataSet dsHeader = BOL.VbecsReport.GetReportHeader(user.UserName);

            ReportDataSource reportSourceMain = new ReportDataSource();
            if (_dsReport.Tables.Count > 0)
            {
                reportSourceMain.Name = "TRWDataSet";
                reportSourceMain.Value = _dsReport.Tables[0];
            }

            ReportDataSource reportSourceHeader = new ReportDataSource();
            if (dsHeader.Tables.Count > 0)
            {
                reportSourceHeader.Name = "ReportHeaderDataSet";
                reportSourceHeader.Value = dsHeader.Tables[0];
            }

            Assembly assembly = Assembly.LoadFrom(Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location) + "\\Reports.dll");
            Stream stream = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TransfusionReactionWorkupReport.rdlc");
            Stream streamSymptoms = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TRWSymptoms.rdlc");
            Stream streamTests = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TRWSerologicTests.rdlc");
            Stream streamUnits = assembly.GetManifestResourceStream("gov.va.med.vbecs.reports.TransfusionReactionWorkupReport.TRWImplicatedUnits.rdlc");

            LocalReport report = new LocalReport();
            report.SubreportProcessing += new SubreportProcessingEventHandler(LoadSubreportsEventHandler);

            report.DataSources.Add(reportSourceHeader);
            report.DataSources.Add(reportSourceMain);
            report.LoadReportDefinition(stream);
            report.LoadSubreportDefinition("TRWSymptoms", streamSymptoms);
            report.LoadSubreportDefinition("TRWSerologicTests", streamTests);
            report.LoadSubreportDefinition("TRWImplicatedUnits", streamUnits);

            return new BOL.VbecsReportPrinter(this.PrinterName, false, report);
        }

        private void LoadSubreportsEventHandler(object sender, SubreportProcessingEventArgs e)
        {
            if (e.ReportPath == "TRWSymptoms" || e.DataSourceNames[0].ToString() == "TRWSymptomsDataSet")
            {
                ReportDataSource reportSymptoms = new ReportDataSource();
                if (_dsReport.Tables.Count > 1)
                {
                    reportSymptoms.Name = "TRWSymptomsDataSet";
                    reportSymptoms.Value = _dsReport.Tables[1];
                }
                e.DataSources.Add(reportSymptoms);
            }
            else if (e.ReportPath == "TRWImplicatedUnits" || e.DataSourceNames[0].ToString() == "TRWImplicatedUnitsDataSet")
            {
                ReportDataSource reportImplicatedUnits = new ReportDataSource();
                if (_dsReport.Tables.Count > 2)
                {
                    reportImplicatedUnits.Name = "TRWImplicatedUnitsDataSet";
                    reportImplicatedUnits.Value = _dsReport.Tables[2];
                }
                e.DataSources.Add(reportImplicatedUnits);
            }
            else if (e.ReportPath == "TRWSerologicTests" || e.DataSourceNames[0].ToString() == "TRWSerologicTestsDataSet")
            {
                ReportDataSource reportSerologicTests = new ReportDataSource();
                if (_dsReport.Tables.Count > 3)
                {
                    reportSerologicTests.Name = "TRWSerologicTestsDataSet";
                    reportSerologicTests.Value = _dsReport.Tables[3];
                }
                e.DataSources.Add(reportSerologicTests);
            }
        }

	}
}
